<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/
namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;
use StemBase\Modules\Shortcodes\Shortcode\Icon;

class CounterCircle extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "countercircle";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[countercicle value=\"80\" /]\n[counterbox value=\"10000\" icon=\"icomoon icon-home\" icon_size=\"30\" title=\"Clients\"/]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(

		array(
			"name"		=> "value",
			"hint"		=> "0-100 percentage of the filled circle"
		),

		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin default. Filled circle"
		),

		array(
			"name"		=> "holder",
			"hint"		=> "#hexcode|transparent, default: skin default. Unfilled circle"
		),

		array(
			"name"		=> "thickness",
			"hint"		=> "value (px), thickness of the circle, default: skin default"
		),

		array(
			"name"		=> "linecap",
			"hint"		=> "round|butt|square, default: round"
		),

		array(
			"name"		=> "res",
			"hint"		=> "none|icon|title|perc, default: perc."
		),

		array(
			"name"		=> "title_size",
			"hint"		=> "value (px|em|rem), default: inherits element size. If no unit is specified px is used"
		),

		array(
			"name"		=> "icon",
			"hint"		=> "icon class, eg: \"icommon icon-checkmark\""
		),

		array(
			"name"		=> "delay",
			"hint"		=> "0-10000 time to wait in miliseconds before starting the animation"
		),

		array(
			"name"		=> "res_size",
			"hint"		=> "value (px|em|rem), default: inherits element size. If no unit is specified px is used"
		),
	
		array(
			"name"		=> "res_color",
			"hint"		=> "#hexcode, default: skin default"
		),


		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {
		global $_MODULES;


		$this->loadTemplate();

		$vars	= $data["vars"];
		$css	= array();
		$style	= array();
		$attrs	= array();

		if ($vars["res_color"]) {
			$style_title[] = $this->getBackground($vars["res_color"] , "color")["bg_style"];
		}

		if ($vars["res_size"]) {
			$style_title[] = "font-size: " . $this->getSize($vars["res_size"]);
		}


		if ($vars["class"]) {
			$css[] = $vars["class"];
		}				
		
		$perc = true;

		switch ($vars["res"]) {

			case "none":
				$res = "";
			break;

			default:
				$res = $this->tpl->blockReplace(
					"Perc",
					array(
						"style_title"	=> implode(" " , $style_title)
					)
				);
			break;

			case "icon":
				$res = $this->tpl->blockreplace(
					"Icon",
					array(
						"content"	=> $_MODULES["shortcodes"]->external["icon"]->render(array(
								"shortcode"	=> "icon",
								"vars"	=> array(
									"icon"	=> $vars["icon"],
									"size"	=> $vars["res_size"],
									"color"	=> $vars["res_color"]
								)
							))["content"]
					)
				);
			break;

			case "title":
				$res = $this->tpl->blockreplace(
					"Title",
					array(
						"title"			=> $vars["title"],
						"style_title"	=> implode(" " , $style_title)
					)
				);
			break;

		}
		

		if ($vars["icon"]) {

			$perc = false;
		}
		

		if ($vars["time"]) {
			$attrs[] = "data-counterup-time=\"{$vars[time]}\"";
		}
		
		
		$info = array(
			"value"			=> $vars["value"],
			"css"			=> implode(" " , $css),
			"color"			=> $vars["color"],
			"thickness"		=> $vars["thickness"],
			"linecap"		=> $vars["linecap"],
			"holder"		=> $vars["holder"],
			"delay"			=> $vars["delay"],
			"perc"			=> $perc ? "true" : "false" ,

			"bg:scheme"		=> "nc",

			"_res"			=> $res,

			"style"			=> implode(" " , $style_content),
			"attrs"			=> implode(" " , $attrs),
		);

		switch ($vars["scheme"]) {
			case "inverted": $info["bg:scheme"] = "ic"; break;
			case "original": $info["bg:scheme"] = "nc"; break;
		}

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				$info,
				$info,	//its double not b
				$this->getBackground($vars["bg"])
			),

			"before"	=> "",
			"after"		=> "",
		);

	}
	
	
}